/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.base.VWDebug;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class VWTaskTimePanel
extends VWTaskTabPanel {
    private int m_timeFormat = 2;
    private boolean m_bOrientIsLeftToRight = ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight();
    private JComboBox m_hours = null;
    private JComboBox m_minutes = null;
    private JComboBox m_ampm = null;
    private static final String AM = "AM";
    private static final String PM = "PM";
    public static final int TIME_FORMAT_12_HOUR = 0;
    public static final int TIME_FORMAT_24_HOUR = 1;
    public static final int TIME_FORMAT_AUTODETECT = 2;

    public VWTaskTimePanel(int timeFormat) {
        boolean localeIs24HourFormat = new SimpleDateFormat().toPattern().indexOf(72) >= 0;
        this.m_timeFormat = timeFormat == 1 || timeFormat == 2 && localeIs24HourFormat ? 1 : 0;
        this.initLayout();
    }

    public void setTime(Calendar time) {
        if (time != null) {
            this.m_minutes.setSelectedItem(this.pad("" + time.get(12)));
            if (this.m_timeFormat == 0) {
                this.m_hours.setSelectedItem(this.pad("" + time.get(10)));
                this.m_ampm.setSelectedItem(time.get(9) == 1 ? PM : AM);
            } else {
                this.m_hours.setSelectedItem(this.pad("" + time.get(11)));
            }
        }
    }

    public void setTime(String theTime, int timeFormat) throws ParseException {
        GregorianCalendar time = new GregorianCalendar();
        time.setTime(this.parseTime(theTime, timeFormat));
        this.setTime(time);
    }

    public Calendar getTime() {
        GregorianCalendar time = new GregorianCalendar();
        String strTime = null;
        try {
            strTime = (String)this.m_hours.getSelectedItem() + ":" + (String)this.m_minutes.getSelectedItem();
            if (this.m_timeFormat == 0) {
                strTime = strTime + " " + (String)this.m_ampm.getSelectedItem();
            }
            time.setTime(this.parseTime(strTime, this.m_timeFormat));
        }
        catch (ParseException e) {
            VWDebug.logException(e, "Exception trying to parse time: " + strTime + " using time format " + this.m_timeFormat);
        }
        return time;
    }

    public String toString() {
        return this.toString(this.m_timeFormat);
    }

    public String toString(int timeFormat) {
        SimpleDateFormat formatter = null;
        formatter = timeFormat == 0 ? (this.m_bOrientIsLeftToRight ? new SimpleDateFormat("hh:mm a", Locale.US) : new SimpleDateFormat("a hh:mm", Locale.US)) : new SimpleDateFormat("HH:mm", Locale.US);
        return formatter.format(this.getTime().getTime());
    }

    public void setEnabled(boolean enabled) {
        this.m_hours.setEnabled(enabled);
        this.m_minutes.setEnabled(enabled);
        if (this.m_ampm != null) {
            this.m_ampm.setEnabled(enabled);
        }
    }

    private Date parseTime(String theTime, int timeFormat) throws ParseException {
        VWDebug.logInfo("Time=" + theTime);
        VWDebug.logInfo("This is a test");
        Date time = null;
        if (timeFormat == 0) {
            VWDebug.logInfo("Parsing time in 12 hour format");
            VWDebug.logInfo("Orientation is left to right: " + this.m_bOrientIsLeftToRight);
            SimpleDateFormat formatter = null;
            formatter = this.m_bOrientIsLeftToRight ? new SimpleDateFormat("hh:mm a", Locale.US) : new SimpleDateFormat("a hh:mm", Locale.US);
            try {
                time = formatter.parse(theTime);
            }
            catch (ParseException e) {
                VWDebug.logException(e, "Exception during first attempt to parse time.");
                formatter = !this.m_bOrientIsLeftToRight ? new SimpleDateFormat("hh:mm a", Locale.US) : new SimpleDateFormat("a hh:mm", Locale.US);
                time = formatter.parse(theTime);
            }
        } else {
            VWDebug.logInfo("Parsing time in 24 hour format");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm", Locale.US);
            time = formatter.parse(theTime);
        }
        return time;
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 0.0;
        c.gridwidth = 1;
        if (this.m_timeFormat == 0 && !this.m_bOrientIsLeftToRight) {
            c.weightx = 0.0;
            c.insets.right = 10;
            this.m_ampm = new JComboBox<String>(new String[]{AM, PM});
            this.add((Component)this.m_ampm, c);
        }
        c.weightx = 0.0;
        c.insets.right = 5;
        this.m_hours = new JComboBox();
        int min = this.m_timeFormat == 0 ? 1 : 0;
        int max = this.m_timeFormat == 0 ? 12 : 23;
        for (int i = min; i <= max; ++i) {
            this.m_hours.addItem(this.pad("" + i));
        }
        this.m_hours.setSelectedItem("12");
        this.add((Component)this.m_hours, c);
        c.weightx = 0.0;
        c.insets.right = 5;
        this.add((Component)new JLabel(":"), c);
        c.weightx = 0.0;
        c.insets.right = 0;
        this.m_minutes = new JComboBox();
        this.m_minutes.addItem("00");
        this.m_minutes.addItem("05");
        this.m_minutes.addItem("10");
        this.m_minutes.addItem("15");
        this.m_minutes.addItem("20");
        this.m_minutes.addItem("25");
        this.m_minutes.addItem("30");
        this.m_minutes.addItem("35");
        this.m_minutes.addItem("40");
        this.m_minutes.addItem("45");
        this.m_minutes.addItem("50");
        this.m_minutes.addItem("55");
        this.add((Component)this.m_minutes, c);
        if (this.m_timeFormat == 0 && this.m_bOrientIsLeftToRight) {
            c.weightx = 0.0;
            c.insets.left = 10;
            c.insets.right = 0;
            this.m_ampm = new JComboBox<String>(new String[]{AM, PM});
            this.add((Component)this.m_ampm, c);
        }
        c.weightx = 1.0;
        this.add(Box.createHorizontalStrut(1), c);
    }

    private String pad(String value) {
        return value.length() == 1 ? "0" + value : value;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   11 Aug 2009 14:12:26  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.8  $";
    }
}

